//CD_SkinForce.c - forces skin to the team and player type

#include "g_local.h"

extern void maxrate_think(edict_t *self);

char Male_Player_Cast[] = "male_thug";
char Female_Player_Cast[] = "female_chick";


char* SetSkin(edict_t *ent, char *SkinString)
{
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/001 001 001");
	else
		strcat(SkinString, "/002 002 002");
	return SkinString;
}

char* SetAssassin(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_FEMALE;
	strcpy(SkinString, "female_chick");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pf1 pf1 pf1");
	else
		strcat(SkinString, "/pf2 pf2 pf2");
	ent->classname = Female_Player_Cast;
	return SkinString;
}

char* SetGangster(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_MALE;
	strcpy(SkinString, "male_thug");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pa1 pa1 pa1");
	else
		strcat(SkinString, "/pa2 pa2 pa2");
	ent->classname = Male_Player_Cast;
	return SkinString;
}

char* SetHoodlum(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_MALE;
	strcpy(SkinString, "male_thug");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pb1 pb1 pb1");
	else
		strcat(SkinString, "/pb2 pb2 pb2");
	ent->classname = Male_Player_Cast;
	return SkinString;
}

char* SetHitman(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_MALE;
	strcpy(SkinString, "male_thug");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pc1 pc1 pc1");
	else
		strcat(SkinString, "/pc2 pc2 pc2");
	ent->classname = Male_Player_Cast;
	return SkinString;
}

char* SetKingpin(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_MALE;
	strcpy(SkinString, "male_thug");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pd1 pd1 pd1");
	else
		strcat(SkinString, "/pd2 pd2 pd2");
	ent->classname = Male_Player_Cast;
	return SkinString;
}

char* SetThug(edict_t *ent, char *SkinString)
{
	ent->gender = GENDER_MALE;
	strcpy(SkinString, "male_thug");
	if(ent->client->pers.team == 1)
		strcat(SkinString, "/pe1 pe1 pe1");
	else
		strcat(SkinString, "/pe2 pe2 pe2");
	ent->classname = Male_Player_Cast;
	return SkinString;
}

//Modified version of routine in p_client.c
void ClientUserinfoChanged (edict_t *ent, char *userinfo)
{
	char	*s;
	int		playernum, rate;
	char	*extras;
	
	// check for malformed or illegal info strings
	if (!Info_Validate(userinfo))
	{
		strcpy (userinfo, "\\name\\badinfo\\skin\\male_thug/009 019 017\\extras\\0");
//do something here, like prevent joining
	}

	// set name
	s = Info_ValueForKey (userinfo, "name");
	strncpy (ent->client->pers.netname, s, sizeof(ent->client->pers.netname)-1);

	// check maxrate
	s = Info_ValueForKey (userinfo, "rate");
	if (s)
	{
		rate = atoi(s);

		if (rate > (int)maxrate->value)
		{
			edict_t *thinker;

			thinker = G_Spawn();
			thinker->think = maxrate_think;
			thinker->nextthink = level.time + 2 + random()*2;
			thinker->owner = ent;
			Info_SetValueForKey( userinfo, "rate", va("%i", (int)maxrate->value) );
		}
	}

	// set skin
	s = Info_ValueForKey (userinfo, "skin");

	// Ridah, HACK for teamplay demo, set skins manually
	if ((deathmatch->value && teamplay->value && ent->client->pers.team) && (ent->client->resp.class_ptr->name != NULL))
	{
		// NOTE: skin order is "HEAD BODY LEGS"
		char Skin[MAX_QPATH];
		char PlayerClass[MAX_QPATH];
		static char* FinalSkin;

		Skin[0] = 0x00;
		strcpy(PlayerClass, ent->client->resp.class_ptr->name);

		if(strcmp(PlayerClass, "Thug") == 0)
			FinalSkin = SetThug(ent, Skin);
		else
			if(strcmp(PlayerClass, "Hitman") == 0)
				FinalSkin = SetHitman(ent, Skin);
			else
				if(strcmp(PlayerClass, "Kingpin") == 0)
					FinalSkin = SetKingpin(ent, Skin);
				else
					if(strcmp(PlayerClass, "Assassin") == 0)
						FinalSkin = SetAssassin(ent, Skin);
					else
						if(strcmp(PlayerClass, "Gangster") == 0)
							FinalSkin = SetGangster(ent, Skin);
						else
							if(strcmp(PlayerClass, "Hoodlum") == 0)
								FinalSkin = SetHoodlum(ent, Skin);

//		gi.cprintf(ent, PRINT_HIGH, "Skin: %s   Class: %s\n", FinalSkin, PlayerClass);

		Info_SetValueForKey( userinfo, "skin", FinalSkin);
	}
	else if (!deathmatch->value)	// enforce thug with single player skin set
	{
		static char *singleplayerskin = "male_thug/018 016 010";

		Info_SetValueForKey( userinfo, "skin", singleplayerskin );
	}

//just to confirm the correct model/skins are selected for debug
	s = Info_ValueForKey (userinfo, "skin");//you need this bit
//	gi.cprintf(ent, PRINT_HIGH, "Skinkey: %s\n", s);//you dont need this bit

//	extras = Info_ValueForKey (userinfo, "extras");
//	extras = "4000\0";//Info_ValueForKey (userinfo, "extras");
//1000 = cap - 2000 = stetson
	if(ent->client->pers.team == 1)
		extras = "9";
	else
		extras = "1";
	playernum = ent-g_edicts-1;

	// combine name and skin into a configstring
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s %s", ent->client->pers.netname, s, extras) );

	// fov
	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}
	// handedness
	s = Info_ValueForKey (userinfo, "hand");
	if (strlen(s))
	{
		ent->client->pers.hand = atoi(s);
	}

	// client exe version
	s = Info_ValueForKey (userinfo, "ver");
	if (s && strlen(s))
	{
		ent->client->pers.version = atoi(s);
	}
	else	// assume client is old version
	{
		ent->client->pers.version = 100;
	}

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, sizeof(ent->client->pers.userinfo)-1);
}